class Relic_HealthRegen extends UniversalSoldiersPickup;

#exec obj load file=..\Textures\Belt_fx.utx package=Belt_fx

#exec Texture Import File=Textures\HealthRegen.bmp Name=HealthRegen Group=Relics MIPS=ON LODSET=2

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
	function Touch( actor Other )
	{
	local US_PRI IPRI;
	local int D;

		if ( Other.IsA('UniversalSoldiersPickup') )
			Self.Destroy();

		if ( ValidTouch(Other) && Other.IsA('PlayerPawn')) 
			{
			if ( !US_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasHealthRegenRelic )
				{
				// Alter player's stats.
				//Pawn(Other).DamageScaling = 3.0;
				
				PlayPickupMessage(PlayerPawn(Other));
				PlaySound (PickupSound,,2.5);
				Other.MakeNoise(0.2);
				US_PRI(PlayerPawn(Other).PlayerReplicationInfo).bHasHealthRegenRelic = True;

				// Add wind blowing.
				//Pawn(Other).AmbientSound = sound'SpeedWind';
				//Pawn(Other).SoundRadius = 64;		
				SetRespawn();
				}
			}
	

	}
	function BeginState()
	{

		SetTimer(1.0,True);
	
	}
}


defaultproperties
{
DrawType=DT_Mesh
Mesh=Mesh'Dollar'
CollisionRadius=26.00000
CollisionHeight=26.00000
MultiSkins(0)=Texture'Belt_fx.ShieldBelt.GreenShield'
MultiSkins(1)=Texture'HealthRegen'
PickupMessage="You picked up the Health regeneration relic"
ItemName="Health Regen relic"
RespawnTime=0.000000
PickupViewMesh=Mesh'Dollar'
PickupSound=Sound'UnrealShare.Generic.RespawnSound'
ScaleGlow=2.000000
bCollideWhenPlacing=True
bRotatingPickup=True
RotationRate=(Roll=12500)
RotationRate=(Pitch=12250)
RotationRate=(Yaw=12000)
}
